import { View, StyleSheet, TouchableHighlight } from "react-native";
import React from "react";
import dpr from "../CustomStyleAttribute/dpr";
import CorrectWhite from "../../../assets/svgs/product details/correctWhite.svg";
import CustomSVG from "../../../src/components/CustomSVG/CustomSVG";

const CustomCheckbox = ({
    handleSelectItem,
    index,
    checked,
    item,
    itemTitle,
}) => {
    return (
        <TouchableHighlight
            onPress={() => handleSelectItem(itemTitle, item, index)}
        >
            {checked ? (
                <View style={styles.checked}>
                    <CustomSVG svgIcon={CorrectWhite} />
                </View>
            ) : (
                <View style={styles.container}></View>
            )}
        </TouchableHighlight>
    );
};

export default CustomCheckbox;

const styles = StyleSheet.create({
    container: {
        borderWidth: 1,
        borderColor: "#DFDFDF",
        height: dpr(20),
        width: dpr(20),
        borderRadius: 2,
    },
    checked: {
        backgroundColor: "#2C2C2C",
        borderRadius: 2,
        height: dpr(20),
        width: dpr(20),
        flexDirection: "row",
        justifyContent: "center",
        alignItems: "center",
    },
});
